function main(self)
	self:AnimationStep()
	local claw = GetClaw()

    if self.State == 0 then
		self:SetImage("CUSTOM_ICESHIELD")
		self:SetAnimation("GAME_CYCLE50")
		self.BumpFlags.EnemyBullet = true
		self.AttackFlags.Enemy = true
		self.HitFlags.Player = true
		self.HitFlags.ThrownObject = true
		self.HitFlags.PistolBullet = true
		self.HitFlags.EnvBullet = true
		self.HitFlags.MagicBullet = true
		self.AttackRect, self.MoveRect, self.HitRect = {-12,-12,12,12}, {-12,-12,12,12}, {-12,-12,12,12}
		self.Flags.AlwaysActive = true
		self.creationTime = GetTime()
		self.timeLimit = GetTime() + 1500 -- lifetime of 1500ms
		self.lastAttempt = Attempt()
		self.shallExplode = false
		self.State = 1
	end

	if self.State == 1 then
		local moveX = (GetTime() - self.creationTime) * self.SpeedX / 1000
		local moveY = (GetTime() - self.creationTime) * self.SpeedY / 1000
		self.X = self.X + moveX
		self.Y = self.Y + moveY

		local isFarFromPlayer = self.X > claw.X + 640 or self.X < claw.X - 640 or self.Y > claw.Y + 480 or self.Y < claw.Y - 480
		if isFarFromPlayer then
			self:Destroy()
		end

		if GetTime() > self.timeLimit then
			self.shallExplode = true
		end

		if self.XMax ~= 0 and self.X > self.XMax then
			self.shallExplode = true
		end

		if self.arcanis and self.arcanis.State == 211 then -- Arcanis STATE.DEFEATED
			self.State = 2 -- stops the projectile
		end
	end

	if self.State > 0 then
		if self.shallExplode then
			CreateObject {x=self.X, y=self.Y, z=6000, name="IceBallExplosion"}
			PlaySound"CLAW_ICESWORD"
			self:Destroy()
		end
		if Attempt() > self.lastAttempt then
			self:Destroy()
		end
	end
end

function hit(self)
	self.shallExplode = true
end
